"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MissingTranslationError = exports.MessageFormatError = exports.MissingDataError = exports.InvalidConfigError = exports.UnsupportedFormatterError = exports.IntlError = exports.IntlErrorCode = void 0;
var tslib_1 = require("tslib");
var IntlErrorCode;
(function (IntlErrorCode) {
    IntlErrorCode["FORMAT_ERROR"] = "FORMAT_ERROR";
    IntlErrorCode["UNSUPPORTED_FORMATTER"] = "UNSUPPORTED_FORMATTER";
    IntlErrorCode["INVALID_CONFIG"] = "INVALID_CONFIG";
    IntlErrorCode["MISSING_DATA"] = "MISSING_DATA";
    IntlErrorCode["MISSING_TRANSLATION"] = "MISSING_TRANSLATION";
})(IntlErrorCode = exports.IntlErrorCode || (exports.IntlErrorCode = {}));
var IntlError = /** @class */ (function (_super) {
    tslib_1.__extends(IntlError, _super);
    function IntlError(code, message, exception) {
        var _this = _super.call(this, "[@formatjs/intl Error " + code + "] " + message + " \n" + (exception ? "\n" + exception.message + "\n" + exception.stack : '')) || this;
        _this.code = code;
        if (typeof Error.captureStackTrace === 'function') {
            Error.captureStackTrace(_this, IntlError);
        }
        return _this;
    }
    return IntlError;
}(Error));
exports.IntlError = IntlError;
var UnsupportedFormatterError = /** @class */ (function (_super) {
    tslib_1.__extends(UnsupportedFormatterError, _super);
    function UnsupportedFormatterError(message, exception) {
        return _super.call(this, IntlErrorCode.UNSUPPORTED_FORMATTER, message, exception) || this;
    }
    return UnsupportedFormatterError;
}(IntlError));
exports.UnsupportedFormatterError = UnsupportedFormatterError;
var InvalidConfigError = /** @class */ (function (_super) {
    tslib_1.__extends(InvalidConfigError, _super);
    function InvalidConfigError(message, exception) {
        return _super.call(this, IntlErrorCode.INVALID_CONFIG, message, exception) || this;
    }
    return InvalidConfigError;
}(IntlError));
exports.InvalidConfigError = InvalidConfigError;
var MissingDataError = /** @class */ (function (_super) {
    tslib_1.__extends(MissingDataError, _super);
    function MissingDataError(message, exception) {
        return _super.call(this, IntlErrorCode.MISSING_DATA, message, exception) || this;
    }
    return MissingDataError;
}(IntlError));
exports.MissingDataError = MissingDataError;
var MessageFormatError = /** @class */ (function (_super) {
    tslib_1.__extends(MessageFormatError, _super);
    function MessageFormatError(message, locale, descriptor, exception) {
        var _this = _super.call(this, IntlErrorCode.FORMAT_ERROR, message + " \nLocale: " + locale + "\nMessageID: " + (descriptor === null || descriptor === void 0 ? void 0 : descriptor.id) + "\nDefault Message: " + (descriptor === null || descriptor === void 0 ? void 0 : descriptor.defaultMessage) + "\nDescription: " + (descriptor === null || descriptor === void 0 ? void 0 : descriptor.description) + " \n", exception) || this;
        _this.descriptor = descriptor;
        return _this;
    }
    return MessageFormatError;
}(IntlError));
exports.MessageFormatError = MessageFormatError;
var MissingTranslationError = /** @class */ (function (_super) {
    tslib_1.__extends(MissingTranslationError, _super);
    function MissingTranslationError(descriptor, locale) {
        var _this = _super.call(this, IntlErrorCode.MISSING_TRANSLATION, "Missing message: \"" + descriptor.id + "\" for locale \"" + locale + "\", using " + (descriptor.defaultMessage ? 'default message' : 'id') + " as fallback.") || this;
        _this.descriptor = descriptor;
        return _this;
    }
    return MissingTranslationError;
}(IntlError));
exports.MissingTranslationError = MissingTranslationError;
